package com.xxfc.service;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.CampSiteApplication;
import com.xxfc.platform.campsite.biz.CampsiteShopBiz;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminFindDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopTagDTO;
import com.xxfc.platform.campsite.vo.CampsiteShopAdminPageVo;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.time.Instant;
import java.util.Arrays;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/19 16:41
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = CampSiteApplication.class)
@Slf4j
public class CampsiteShopBizTest {


    @Autowired
    private CampsiteShopBiz campsiteShopBiz;


    @Test
    public  void testList(){
        CampsiteShopAdminFindDTO campsiteShopAdminFindDTO = new CampsiteShopAdminFindDTO();
        campsiteShopAdminFindDTO.setName("kon");
        Instant now = Instant.now();
        long start = now.minusMillis(3 * 24 * 60 * 60 * 1000).toEpochMilli();
        campsiteShopAdminFindDTO.setStartTime(start);
        campsiteShopAdminFindDTO.setEndTime(now.toEpochMilli());
        campsiteShopAdminFindDTO.setPage(1);
        campsiteShopAdminFindDTO.setLimit(10);
        PageDataVO<CampsiteShopAdminPageVo> campsiteShopPage = campsiteShopBiz.findCampsiteShopPage(campsiteShopAdminFindDTO);
        System.out.println(campsiteShopPage.getData());
    }

    @Test
    public void testSae(){
        CampsiteShopAdminDTO campsiteShopAdminDTO = new CampsiteShopAdminDTO();
       // campsiteShopAdminDTO.setId(13);
        campsiteShopAdminDTO.setProvince(2323);
        campsiteShopAdminDTO.setProvinceName("浙江省");
        campsiteShopAdminDTO.setCity(2342342);
        campsiteShopAdminDTO.setCityName("台州市");
        campsiteShopAdminDTO.setAddress("胡同路23号");
        campsiteShopAdminDTO.setConcat("zhangsan");
        campsiteShopAdminDTO.setConfigure("dsaasdfasdfa");
        campsiteShopAdminDTO.setContent("sadfasdfasdfasd");
        campsiteShopAdminDTO.setHot(23);
        campsiteShopAdminDTO.setLogo("https://xxtest.upyuns.com/image/admin/2019-06-13/23.png");
        campsiteShopAdminDTO.setName("kong");
        campsiteShopAdminDTO.setPhone("132121212121");
        campsiteShopAdminDTO.setServicePhone("4545454545");
        campsiteShopAdminDTO.setLatitude(39.983171);
        campsiteShopAdminDTO.setLongitude(116.308479);

        CampsiteShopCarouselDTO campsiteShopCarouselDTO = new CampsiteShopCarouselDTO();
        //campsiteShopCarouselDTO.setId(12);
        campsiteShopCarouselDTO.setImgUrl("https://xxtest.upyuns.com/image/admin/2019-06-13/23.png");
        campsiteShopAdminDTO.setCarouselDTOS(Arrays.asList(campsiteShopCarouselDTO));


        campsiteShopAdminDTO.setCampsiteTagDTOS(Arrays.asList(1));
        System.out.println("保存的json信息：【{}】"+JSONObject.toJSONString(campsiteShopAdminDTO));

       campsiteShopBiz.saveCampsiteShop(campsiteShopAdminDTO);
    }
}
