package com.xxfc.platform.campsite.biz;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.sun.org.apache.regexp.internal.RE;
import com.xxfc.platform.campsite.dto.CampsiteTagListDTO;
import com.xxfc.platform.campsite.vo.CampsiteTagListVo;
import com.xxfc.platform.campsite.vo.CampsiteTagVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.campsite.entity.CampsiteTag;
import com.xxfc.platform.campsite.mapper.CampsiteTagMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.Comparator;
import java.util.List;

/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Service
public class CampsiteTagBiz extends BaseBiz<CampsiteTagMapper,CampsiteTag> {

    /**
     * 查询营地列表
     * @return
     */
    public List<CampsiteTagListVo> findCampsiteTags() {
        List<CampsiteTagListDTO> campsiteTagListDTOS = mapper.findAllCampsiteTags();
        if (CollectionUtils.isEmpty(campsiteTagListDTOS)){
            return  null;
        }
        List<CampsiteTagListVo> campsiteTagListVos = JSONObject.parseObject(JSONObject.toJSONString(campsiteTagListDTOS),new TypeReference<List<CampsiteTagListVo>>(){});
        return campsiteTagListVos;
    }

    /**
     * 更新营地类型状态
     * @param tagId
     * @return
     */
    public int updateCampsiteTagStatus(Integer tagId) {
       return mapper.updateCampsiteTagStatusById(tagId,1);
    }

    /**
     * 分页查询
     * @param page
     * @param limit
     * @return
     */
    public PageDataVO<CampsiteTagVo> findCampsiteTagsPage(Integer page, Integer limit) {
        PageDataVO<CampsiteTagVo> tagVoPageDataVO = new PageDataVO<>();
        PageDataVO<CampsiteTag> pageDataVO = PageDataVO.pageInfo(page, limit, () -> mapper.findAllCampsiteTagsBydelStatus());
        List<CampsiteTag> campsiteTags = pageDataVO.getData();
        if (CollectionUtils.isEmpty(campsiteTags)){
            return tagVoPageDataVO;
        }
        tagVoPageDataVO = JSONObject.parseObject(JSONObject.toJSONString(pageDataVO),new TypeReference<PageDataVO<CampsiteTagVo>>(){});
        tagVoPageDataVO.getData().sort(Comparator.comparing(CampsiteTagVo::getRank).reversed().thenComparing(Comparator.comparing(CampsiteTagVo::getCtrTime).reversed()));
        return tagVoPageDataVO;
    }

    /**
     * 更改是否作为筛选条件
     * @param id
     * @param status
     * @return
     */
    public int updateCampsiteTagIsSearchStatus(Integer id, Integer status) {
       return   mapper.updateCampsiteTagIsearchStatusById(id,status);
    }

    /**
     * 营地类型名检验
     * @param id
     * @param name
     * @return
     */
    public Boolean checkTagNameExist(Integer id, String name) {
         int count  = mapper.checkTagNameExist(id,name);
         if (count == 0){
             return false;
         }
         return  true;
    }
}