package com.xxfc.platform.campsite.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 营地店铺表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@ApiModel(value = "营地店铺vo")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CampsiteShopPageVo implements Serializable {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 店铺名称
     */
    @ApiModelProperty(value = "店铺名称")
    private String name;

    /**
     * 店铺logo
     */
    @ApiModelProperty(value = "店铺logo")
    private String logo;

    /**
     * 店铺URL
     */
    @ApiModelProperty(value = "店铺URL")
    private String url;

    /**
     * 地址-省/直辖市(名称)
     */
    @ApiModelProperty(value = "地址-省/直辖市(名称)")
    private String provinceName;

    /**
     * 地址-市(名称)
     */
    @ApiModelProperty(value = "地址-市(名称)")
    private String cityName;

    /**
     * 店铺类型名称
     */
    @ApiModelProperty(value = "店铺类型名称")
    private String  storeTypeName;

    /**
     * 店铺类型id
     */
    @ApiModelProperty(value = "店铺类型id")
    private String storeId;


    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private Double longitude;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    /**
     * 热度值
     */
    @ApiModelProperty(value = "热度值")
    private Integer hot;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

}
