package com.xxfc.platform.activity.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;


/**
 * 我的优惠卷
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 14:34:49
 */
@Data
public class UserCouponVo {


	
	/**
     *  优惠卡券id
     */
	@ApiModelProperty(value = "优惠卡券id")
    private Integer couponId;
	
	/**
     *  用户id
     */
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  券号
     */
	@ApiModelProperty(value = "券号")
    private String tickerNo;
	
	    /**
     *  0-未使用；1-已使用
     */
	@ApiModelProperty(value = "0-未使用；1-已使用")
    private Integer isUse;
	
	    /**
     *  使用订单号
     */
	@ApiModelProperty(value = "使用订单号")
    private String orderNo;
	
	/**
     *  领卷时间
     */
	@ApiModelProperty(value = "领卷时间", hidden = true )
    private Long crtTime;

	/**
	 *  开始时间
	 */
	@ApiModelProperty(value = "开始时间", hidden = true )
	private Long startTime;

	/**
	 *  到期时间
	 */
	@ApiModelProperty(value = "到期时间", hidden = true )
	private Long expireTime;
	
	/**
     *  使用时间
     */
	@ApiModelProperty(value = "使用时间")
    private Long useTime;

	/**
	 *  优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元
	 */
	@ApiModelProperty(value = "优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元")
	private String title;

	/**
	 *  图片
	 */
	@ApiModelProperty(value = "图片")
	private String icon;

	/**
	 *  可用于：10店铺优惠券 11新人店铺券  20商品优惠券  30类目优惠券  60平台优惠券 61新人平台券
	 */
	@ApiModelProperty(value = "可用于：10店铺优惠券 11新人店铺券  20商品优惠券  30类目优惠券  60平台优惠券 61新人平台券")
	private Integer used;

	/**
	 *  0-全平台；1-租车；2-旅游；3-营地
	 */
	@ApiModelProperty(value = "0-全平台；1-租车；2-旅游；3-营地")
	private Integer channel;

	/**
	 *  0-普通用户；1-会员用户
	 */
	@ApiModelProperty(value = "0-普通用户；1-会员用户")
	private Integer userType;

	/**
	 *  1满减券 2叠加满减券 3无门槛券（需要限制大小）
	 */
	@ApiModelProperty(value = "1满减券 2叠加满减券 3无门槛券（需要限制大小）")
	private Integer type;

	/**
	 *  1可用于特价商品 2不能  默认不能(商品优惠卷除外)
	 */
	@ApiModelProperty(value = "1可用于特价商品 2不能  默认不能(商品优惠卷除外)")
	private Integer withSpecial;

	/**
	 *  店铺或商品流水号
	 */
	@ApiModelProperty(value = "店铺或商品流水号")
	private String withSn;

	/**
	 *  满多少金额
	 */
	@ApiModelProperty(value = "满多少金额")
	private BigDecimal withAmount;

	/**
	 *  用券抵扣金额
	 */
	@ApiModelProperty(value = "用券抵扣金额")
	private BigDecimal usedAmount;


	/**
	 *  1生效 2失效 3已结束
	 */
	@ApiModelProperty(value = "1生效 2失效 3已结束")
	private Integer status;

	/**
	 *  跳转链接
	 */
	@ApiModelProperty(value = "跳转链接")
	private String url;
	

}
