package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.biz.MenuBiz;
import com.github.wxiaoqi.security.admin.biz.UserBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.Menu;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.rpc.service.PermissionService;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.admin.vo.FrontUser;
import com.github.wxiaoqi.security.admin.vo.MenuTree;
import com.github.wxiaoqi.security.admin.vo.UserMemberVo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import io.swagger.models.auth.In;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("public")
public class PublicController {

    @Autowired
    private UserBiz userBiz;

    @Autowired
    private AppUserDetailBiz detailBiz;
    @Autowired
    private BaseUserMemberBiz userMemberBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @RequestMapping(value = "/userinfo-by-token", method = RequestMethod.GET)
    public @ResponseBody
    ObjectRestResponse userinfoByToken(String token) throws Exception {
        String username = userAuthUtil.getInfoFromToken(token).getUniqueName();
        if (username == null) {
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        }
        User user = userBiz.getUserByUsername(username);
        if (user == null) {
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        }
        return new ObjectRestResponse<User>().rel(true).data(user);
    }

    @RequestMapping(value = "/app/userinfo-by-token", method = RequestMethod.GET)
    public @ResponseBody
    ObjectRestResponse userDetailByToken(String token) throws Exception {
        String username = userAuthUtil.getInfoFromToken(token).getId();
        if (username == null) {
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        }
        AppUserDTO userDTO=new AppUserDTO();
        Integer userid = Integer.parseInt(username);
        //获取用户基础信息
        AppUserVo userVo = detailBiz.getUserInfoById(userid);
        if (userVo == null) {
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        }
        BeanUtils.copyProperties(userDTO,userVo);
        if(userVo.getIsMember()!=null&&userVo.getIsMember()>0){
            //获取用户会员信息
            UserMemberVo memberVo=userMemberBiz.getMemberInfoByUserId(userid);
            if(memberVo!=null){
                BeanUtils.copyProperties(userDTO,memberVo);
            }
        }
        return new ObjectRestResponse<AppUserDetail>().rel(true).data(userDTO);
    }

    @RequestMapping(value = "/userinfo-by-uid", method = RequestMethod.GET)
    public @ResponseBody
    ObjectRestResponse userinfoByUid(Integer uid) throws Exception {
        if (uid == null||uid==0) {
            throw new BaseException();
        }
        User user = userBiz.getUserByUid(uid);
        if (user == null) {
            throw new BaseException();
        }
        return new ObjectRestResponse<User>().rel(true).data(user);
    }

    @GetMapping("/getByUserIds")
    public ObjectRestResponse<List<AppUserVo>> getByUserIds(@RequestParam("ids") List<Integer> ids) {
        if(ids == null) {
            return ObjectRestResponse.createFailedResult(500, "参数id为空");
        }
        List<AppUserVo> appUserVos = new ArrayList<>();
        for (Integer id : ids) {
            AppUserVo userVo = detailBiz.getUserInfoById(id);
            appUserVos.add(userVo);
        }

        return ObjectRestResponse.succ(appUserVos);
    }


}
