package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.mapper.*;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;



/**
 * app用户管理业务逻辑层
 *
 * @author Administrator
 */
@Service
public class AppUserManageBiz extends BaseBiz<AppUserDetailMapper, AppUserDetail> {

    @Autowired
    private AppUserLoginMapper appUserLoginMapper;

    /**
     * 根据条件查询
     *
     * @param appUserVo
     * @return
     */
    public AppUserVo findAllByQuery(AppUserVo appUserVo) {
        return mapper.selectAppUserManage(appUserVo);
    }


    @Transactional
    public void deleteAppUser(Integer id) {
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setIsdel(1);
        Example example = new Example(AppUserLogin.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", id);
        appUserLogin.setUpdatetime(System.currentTimeMillis());
        appUserLoginMapper.updateByExampleSelective(appUserLogin, example);

        AppUserDetail appUserDetail = new AppUserDetail();
        appUserDetail.setIsdel(1);
        appUserDetail.setUpdatetime(System.currentTimeMillis());
        Example detailExample = new Example(AppUserLogin.class);
        Example.Criteria detailCriteria = detailExample.createCriteria();
        criteria.andEqualTo("id", id);
        mapper.updateByExampleSelective(appUserDetail, detailCriteria);

    }

    public AppUserVo findOneById(Integer id) {
        return mapper.getUserInfo(id);
    }

    @Transactional
    public void save(AppUserVo appUserVo) {
        AppUserLogin appUserLogin = new AppUserLogin();
        AppUserDetail appUserDetail = new AppUserDetail();

        try {

            BeanUtilsBean.getInstance().copyProperties(appUserLogin, appUserVo);
            BeanUtilsBean.getInstance().copyProperties(appUserDetail, appUserVo);

            if (appUserVo.getUserid() == null || appUserVo.getUserid() == 0) {


                //设置登录用户信息
                appUserLogin.setIsdel(0);
                appUserLogin.setCreatetime(System.currentTimeMillis());
                appUserLogin.setCertificationStatus(0);
                appUserLogin.setStatus(0);
                //设置用户详情
                appUserDetail.setIsdel(0);
                if (appUserDetail.getIsMember() == null) {
                    appUserDetail.setIsMember(0);
                }

                appUserLoginMapper.insertSelective(appUserLogin);
                mapper.insertSelective(appUserDetail);

            } else {
                appUserLogin.setUpdatetime(System.currentTimeMillis());
                appUserDetail.setUpdatetime(System.currentTimeMillis());
                appUserLoginMapper.updateByPrimaryKeySelective(appUserLogin);
                mapper.updateByPrimaryKeySelective(appUserDetail);
            }
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }
}
