package com.github.wxiaoqi.security.admin.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.mapper.AppUserDetailMapper;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 16:23
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AppUserDetailBiz extends BaseBiz<AppUserDetailMapper, AppUserDetail> {


    @Override
    @CacheClear(pre="user{1.userid}")
    public void updateSelectiveById(AppUserDetail entity) {
        super.updateSelectiveById(entity);
    }

    /**
     * 根据用户id获取用户信息
     * @param userid
     * @return
     */
    public AppUserDetail getUserByUserid(Integer userid) {
        Example example = new Example(AppUserDetail.class);
        example.createCriteria().andEqualTo("userid", userid).andEqualTo("isdel", 0);
        List<AppUserDetail> list = mapper.selectByExample(example);
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    /**
     * 获取用户信息
     * @param userid
     * @return
     */
    @Cache(key="user{1}")
    public AppUserVo getUserInfoById(Integer userid){
        return mapper.getUserInfo(userid);
    }

    /**
     * 更新用户信息
     * @param userVo
     */
    @CacheClear(pre="user{1.userid}")
    public void updUuserInfoById(AppUserVo userVo){
        AppUserDetail entity =new  AppUserDetail();
        try {
            BeanUtils.copyProperties(entity,userVo);
            if(entity!=null){
                super.updateSelectiveById(entity);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }







}
