/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.metric;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.util.courier.StringUtils;
import com.taobao.csp.sentinel.dashboard.datasource.entity.MetricEntity;
import com.taobao.csp.sentinel.dashboard.discovery.AppManagement;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.inmem.InMemMetricStore;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricFetcher {
    private static Logger logger = LoggerFactory.getLogger(MetricFetcher.class);
    private static final int HTTP_OK = 200;
    public static final long MAX_CLIENT_LIVE_TIME_MS = 300000L;
    private static final long MAX_LAST_FETCH_INTERVAL_MS = 15000L;
    private static final long FETCH_INTERVAL_SECOND = 6L;
    private static final Charset DEFAULT_CHARSET = Charset.forName(SentinelConfig.charset());
    private static final String METRIC_URL_PATH = "metric";
    private final long intervalSecond = 1L;
    private Map<String, AtomicLong> appLastFetchTime = new ConcurrentHashMap();
    @Autowired
    private InMemMetricStore metricStore;
    @Autowired
    private AppManagement appManagement;
    private CloseableHttpAsyncClient httpclient;
    private ScheduledExecutorService fetchScheduleService = Executors.newScheduledThreadPool(1);
    private ExecutorService fetchService;
    private ExecutorService fetchWorker;

    public MetricFetcher() {
        int cores = Runtime.getRuntime().availableProcessors() * 2;
        long keepAliveTime = 0L;
        int queueSize = 2048;
        ThreadPoolExecutor.DiscardPolicy handler = new ThreadPoolExecutor.DiscardPolicy();
        this.fetchService = new ThreadPoolExecutor(cores, cores, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), (ThreadFactory)new NamedThreadFactory("fetchService"), handler);
        this.fetchWorker = new ThreadPoolExecutor(cores, cores, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), (ThreadFactory)new NamedThreadFactory("fetchWorker"), handler);
        IOReactorConfig ioConfig = IOReactorConfig.custom().setConnectTimeout(3000).setSoTimeout(3000).setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).build();
        this.httpclient = HttpAsyncClients.custom().setRedirectStrategy((RedirectStrategy)new /* Unavailable Anonymous Inner Class!! */).setMaxConnTotal(4000).setMaxConnPerRoute(1000).setDefaultIOReactorConfig(ioConfig).build();
        this.httpclient.start();
        this.start();
    }

    private void start() {
        this.fetchScheduleService.scheduleAtFixedRate(() -> {
            try {
                this.fetchAllApp();
            }
            catch (Exception e) {
                logger.info("fetchAllApp error:", (Throwable)e);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
    }

    private void writeMetric(Map<String, MetricEntity> map) {
        if (map.isEmpty()) {
            return;
        }
        Date date = new Date();
        for (MetricEntity entity : map.values()) {
            entity.setGmtCreate(date);
            entity.setGmtModified(date);
        }
        this.metricStore.saveAll(map.values());
    }

    private void fetchAllApp() {
        List apps = this.appManagement.getAppNames();
        if (apps == null) {
            return;
        }
        for (String app : apps) {
            this.fetchService.submit(() -> {
                try {
                    this.doFetchAppMetric(app);
                }
                catch (Exception e) {
                    logger.error("fetchAppMetric error", (Throwable)e);
                }
            });
        }
    }

    private void fetchOnce(String app, long startTime, long endTime, int maxWaitSeconds) {
        if (maxWaitSeconds <= 0) {
            throw new IllegalArgumentException("maxWaitSeconds must > 0, but " + maxWaitSeconds);
        }
        Set machines = this.appManagement.getDetailApp(app).getMachines();
        logger.debug("enter fetchOnce(" + app + "), machines.size()=" + machines.size() + ", time intervalMs [" + startTime + ", " + endTime + "]");
        if (machines.isEmpty()) {
            return;
        }
        String msg = "fetch";
        AtomicLong dead = new AtomicLong();
        AtomicLong success = new AtomicLong();
        AtomicLong fail = new AtomicLong();
        long start = System.currentTimeMillis();
        ConcurrentHashMap metricMap = new ConcurrentHashMap(16);
        CountDownLatch latch = new CountDownLatch(machines.size());
        for (MachineInfo machine : machines) {
            if (System.currentTimeMillis() - machine.getVersion().getTime() > 300000L) {
                latch.countDown();
                dead.incrementAndGet();
                continue;
            }
            String url = "http://" + machine.getIp() + ":" + machine.getPort() + "/" + METRIC_URL_PATH + "?startTime=" + startTime + "&endTime=" + endTime + "&refetch=" + false;
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Connection", "Close");
            this.httpclient.execute((HttpUriRequest)httpGet, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        try {
            latch.await(maxWaitSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("fetch metric, wait http client error:", (Throwable)e);
        }
        long cost = System.currentTimeMillis() - start;
        this.writeMetric(metricMap);
    }

    private void doFetchAppMetric(String app) {
        long endTime;
        long now = System.currentTimeMillis();
        long lastFetchMs = now - 15000L;
        if (this.appLastFetchTime.containsKey(app)) {
            lastFetchMs = Math.max(lastFetchMs, ((AtomicLong)this.appLastFetchTime.get(app)).get() + 1000L);
        }
        if ((endTime = (lastFetchMs = lastFetchMs / 1000L * 1000L) + 6000L) > now - 2000L) {
            return;
        }
        this.appLastFetchTime.computeIfAbsent(app, a -> new AtomicLong()).set(endTime);
        long finalLastFetchMs = lastFetchMs;
        long finalEndTime = endTime;
        try {
            this.fetchWorker.submit(() -> {
                try {
                    this.fetchOnce(app, finalLastFetchMs, finalEndTime, 5);
                }
                catch (Exception e) {
                    logger.info("fetchOnce(" + app + ") error", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.info("submit fetchOnce(" + app + ") fail, intervalMs [" + lastFetchMs + ", " + endTime + "]", (Throwable)e);
        }
    }

    private void handleResponse(HttpResponse response, MachineInfo machine, Map<String, MetricEntity> metricMap) throws Exception {
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            return;
        }
        Charset charset = null;
        try {
            String contentTypeStr = response.getFirstHeader("Content-type").getValue();
            ContentType contentType = ContentType.parse((String)contentTypeStr);
            charset = contentType.getCharset();
        }
        catch (Exception contentTypeStr) {
            // empty catch block
        }
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)(charset != null ? charset : DEFAULT_CHARSET));
        if (StringUtils.isEmpty((String)body)) {
            return;
        }
        String[] lines = body.split("\n");
        this.handleBody(lines, machine, metricMap);
    }

    private void handleBody(String[] lines, MachineInfo machine, Map<String, MetricEntity> map) {
        if (lines.length < 1) {
            return;
        }
        for (String line : lines) {
            try {
                MetricNode node = MetricNode.fromThinString((String)line);
                String key = this.buildMetricKey(machine.getApp(), node.getName(), node.getTimestamp());
                MetricEntity entity = map.get(key);
                if (entity != null) {
                    entity.addPassedQps(Long.valueOf(node.getPassedQps()));
                    entity.addBlockedQps(Long.valueOf(node.getBlockedQps()));
                    entity.addRtAndSuccessQps((double)node.getRt(), Long.valueOf(node.getSuccessQps()));
                    entity.addException(Long.valueOf(node.getException()));
                    entity.addCount(1);
                    continue;
                }
                entity = new MetricEntity();
                entity.setApp(machine.getApp());
                entity.setTimestamp(new Date(node.getTimestamp()));
                entity.setPassedQps(Long.valueOf(node.getPassedQps()));
                entity.setBlockedQps(Long.valueOf(node.getBlockedQps()));
                entity.setSuccessQps(Long.valueOf(node.getSuccessQps()));
                entity.setException(Long.valueOf(node.getException()));
                entity.setRt((double)node.getRt());
                entity.setCount(1);
                entity.setResource(node.getName());
                map.put(key, entity);
            }
            catch (Exception e) {
                logger.info("handleBody line error: {}", (Object)line);
            }
        }
    }

    private String buildMetricKey(String app, String resource, long timestamp) {
        return app + "__" + resource + "__" + timestamp / 1000L;
    }

    static /* synthetic */ void access$000(MetricFetcher x0, HttpResponse x1, MachineInfo x2, Map x3) throws Exception {
        x0.handleResponse(x1, x2, x3);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

