package com.xxfc.platform.vehicle.rest.admin;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.BranchCompanyBiz;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
 * 获取公司所在的城市
 *
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("/city")
public class CityController extends BaseController<VehicleBiz> {
    @Autowired
    private  BranchCompanyBiz branchCompanyBiz;



    /**
     * 获取公司所在的城市
     *
     * @param zoneList
     * @param companyList
     * @return
     */
    @GetMapping("/corporationCity")
    public ObjectRestResponse<Set<Integer>> corporationCity(
            @RequestParam(value = "zoneList",defaultValue = "") String zoneList,
            @RequestParam(value = "companyList",defaultValue = "") String companyList) {
        return ObjectRestResponse.succ(branchCompanyBiz.getCity(zoneList,companyList));
    }
}
