package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.VehicleLicenseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.common.VehicleBaseController;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import com.xxfc.platform.vehicle.pojo.QueryMultiDTO;
import com.xxfc.platform.vehicle.pojo.VehicleUserLicenseVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/user")
@Slf4j
@IgnoreClientToken
@Api(value="常用驾驶人管理controller",tags={"常用驾驶人管理接口"})
public class VehicleLicenseController extends VehicleBaseController<VehicleLicenseBiz> {


    @RequestMapping(value = "/license/update", method = RequestMethod.POST)
    public RestResponse update(@RequestBody VehicleUserLicenseVo licenseVo) throws Exception {
        AppUserDTO userDTO =getUserInfo();
        if(userDTO==null){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        licenseVo.setUserid(userDTO.getUserid());
        return baseBiz.update(licenseVo);
    }

    @RequestMapping(value = "/license/all", method = RequestMethod.POST)
    public RestResponse<PageDataVO<VehicleUserLicense>> all(
            @RequestParam(value="page",defaultValue="1")Integer  page,
            @RequestParam(value="limit",defaultValue="10")Integer  limit) throws Exception {
        AppUserDTO userDTO =getUserInfo();
          if(userDTO==null){
              return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
          }
        return RestResponse.suc(baseBiz.getAllByUserid( page,limit,userDTO.getUserid()));
    }
    @RequestMapping(value = "/license/one", method = RequestMethod.GET)
    public RestResponse<VehicleUserLicense> one(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception {
        AppUserDTO userDTO =getUserInfo();
        if(userDTO==null||id==0){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return RestResponse.suc(baseBiz.getOneById(id));
    }
    @RequestMapping(value = "/license/company/getOne", method = RequestMethod.GET)
    @IgnoreUserToken
    @IgnoreClientToken
    public RestResponse<VehicleUserLicense> getOne(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception {
        return RestResponse.suc(baseBiz.getOneById(id));
    }
    @ApiOperation("多个驾驶员查询")
    @RequestMapping(value = "/license/multi", method = RequestMethod.GET)
    public ObjectRestResponse<List<VehicleUserLicense>> multi(QueryMultiDTO dto) throws Exception {
//        BaseContextHandler.getUserID()
        log.info("获取驾驶人信息：", dto.toString());
        List<VehicleUserLicense> list = baseBiz.selectByExample(new Example.Builder(VehicleUserLicense.class)
                .where(WeekendSqls.<VehicleUserLicense>custom()
                        .andIn(VehicleUserLicense::getId, Arrays.asList(dto.getIds().split(",")))).build());
        return ObjectRestResponse.succ().data(list);
    }


    @GetMapping("/license/getVehicleLicenseList")
    public ObjectRestResponse<List<VehicleUserLicense>> getVehicleLicenseList(String ids){
//        BaseContextHandler.getUserID()
        log.info("获取驾驶人信息：", ids);
        List<VehicleUserLicense> list = new ArrayList<>();
        if(StringUtils.isNotBlank(ids)) {
           List<String> idList = Arrays.asList(ids.split(","));
           for(String id : idList) {
               VehicleUserLicense vehicleUserLicense = baseBiz.selectById(id);
               if(vehicleUserLicense != null) {
                   list.add(vehicleUserLicense);
               }
           }
        }
        return ObjectRestResponse.succ().data(list);
    }


    @RequestMapping(value = "/license/del", method = RequestMethod.GET)
    public RestResponse del(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception {
        if(id==0){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.del(id);
    }



}
