package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车型
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-21 14:15:27
 */
public interface VehicleModelMapper extends Mapper<VehicleModel> {

    List<VehicleModelVo> findVehicleModelPage(VehicleModelQueryCondition vmqc);

    /**
     * 根据车型id和车型某个订单的评价的平均分值计算
     * @param modelId
     * @param avgScore
     * @return
     */
    int updateScoreByModelIdAndavgScore(@Param("modelId") Integer modelId, @Param("avgScore") int avgScore);

    @Select("select `price` from `vehicle_model` where `id`=#{vehicleModelId}")
    BigDecimal selectPriceById(@Param("vehicleModelId") Integer vehicleModelId);

    @Select({"select `id` AS `vehicleModelId`,`name`,`price` AS `basePrice` from `vehicle_model` where `isdel`=0"})
    @ResultType(value = VehicleModelDTO.class)
    List<VehicleModelDTO> findAllVehicleModel();
}
