package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.VehicleDepartureLog;
import com.xxfc.platform.vehicle.pojo.DepartureLogVo;
import com.xxfc.platform.vehicle.pojo.VehicleDepartureLogVo;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.BaseMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface VehicleDepartureLogMapper extends BaseMapper<VehicleDepartureLog>, Mapper<VehicleDepartureLog> {

    VehicleDepartureLog selectLastByVehicleId(String vehicleId);

    List<VehicleDepartureLogVo> selectByVehicleId(String vehicleId);
    List<VehicleDepartureLog> selectByVehicle(String vehicleId);
    List<VehicleDepartureLogVo> selectVoAll(@Param("numberPlate") String numberPlate,
                                            @Param("code") Integer code,
                                            @Param("zoneId") Integer zoneId,
                                            @Param("departureId") Integer departureId,
                                            @Param("arrivalBranchCompanyId") Integer arrivalBranchCompanyId,
                                            @Param("use") String user,
                                            @Param("startTime") String startTime,
                                            @Param("endTime") String endTime
    );

    List<VehicleDepartureLogVo> selectVoAllNotAllData(@Param("numberPlate") String numberPlate,
                                                      @Param("code") Integer code,
                                                      @Param("zoneId") Integer zoneId,
                                                      @Param("departureId") Integer departureId,
                                                      @Param("arrivalBranchCompanyId") Integer arrivalBranchCompanyId,
                                                      @Param("use") String user,
                                                      @Param("startTime") String startTime,
                                                      @Param("endTime") String endTime,
                                                      @Param("companyList") List<Integer> companyList);

    Integer selectMileageByVehicleId(String vehicleId);

    String selectDayByVehicleId(String vehicleId);

    VehicleDepartureLogVo selectByBookRecordId(Long bookRecordId);
    Integer selectAllDepartureLog(Map<String, Object> param);
}
