package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.VehicleBookInfo;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface VehicleBookInfoMapper extends Mapper<VehicleBookInfo> {
    /**
     * 根据车辆id和对应年月查询预定记录
     * @param params
     * @return
     */
    public List<VehicleBookInfo> getByVehicleIdAndYearMonth(Map<String, Object> params);

    /**
     * 根据车辆id和对应年月查询预定记录
     * @param params
     * @return
     */
    public List<VehicleBookInfo> getByVehicleIdAndYearMonths(Map<String, Object> params);

    /**
     * 不存在插入、存在更新
     * @param vehicleBookInfo
     * @return
     */
    public Integer insertIgnore(VehicleBookInfo vehicleBookInfo);

    /**
     * 更新预定信息，如果位操作正确的话（以此实现未预定才预定，已预定才可取消）
     * @param params
     * @return
     */
    public Integer updateBookedInfo(Map<String, Object> params);

    public void createTbIfNotExists(String tbName);

    public List<VehicleBookInfo> getByPage4YearMonth(Map<String, Object> params);

    public Integer insertHis(Map<String, Object> params);

    public Integer del4YearMoth(Map<String, Object> params);

    void insertBatch(@Param("vbfs") List<VehicleBookInfo> bookInfos);

    public Integer updateById(VehicleBookInfo vehicleBookInfo);
}