package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 车辆活动日志
 */
@Table(name = "vehicle_active_log")
@Data
public class VehicleActiveLog {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    Integer id;
    /**
     * 车辆ID
     */
    String vehicleId;
    /**
     * 活动类型
     * VehicleActiveType
     */
    Integer activeType;
    /**
     * 开始时间
     */
    Date startTime;
    /**
     * 结束时间
     */
    Date endTime;
    /**
     * 创建时间
     */
    Date createTime;
    /**
     * 修改时间
     */
    Date updateTime;

}
