package com.xxfc.platform.vehicle.entity;

import com.xxfc.platform.vehicle.constant.AccompanyingItemType;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 
 * @data 2019/8/2 16:52
 */
@Data
public class AccompanyingItem {

    public static final Integer NO_AMOUNT_LIMIT = -1;

    @Id
    private Integer id;

    /**
     * 物品类型，详见{@link AccompanyingItemType}
     */
    @Column(name = "type" )
    private Integer type;

    /**
     * 物品名称
     */
    @Column(name = "name")
    private String name;

    /**
     *标配数量
     */
    @Column(name = "number")
    private Integer number;

    @Column(name = "rank")
    private Integer rank;

    /**
     *单位
     */
    @Column(name = "unit")
    private String unit;

    /**
     *价格
     */
    @Column(name = "price")
    private BigDecimal price;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "is_del")
    private Integer isDel;
}
