package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;

import com.xxfc.platform.universal.service.TrafficViolationsService;
import com.xxfc.platform.universal.vo.RentViolationDTO;
import com.xxfc.platform.universal.vo.TrafficViolations;
import com.xxfc.platform.universal.vo.ViolationVO;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("3p/tv")
@Slf4j
public class TrafficViolationsController {
    @Autowired
     private VehicleFeign vehicleFeign;
    @Autowired
    TrafficViolationsService tvService;

    /**
     * 获取支持的城市
     * @return
     */
    @GetMapping("/city")
    public ObjectRestResponse getCityInfo() {
        try {
            return  ObjectRestResponse.succ(JSONObject.parse(tvService.getCity()));
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 违章车辆查询
     * @return
     */
    @PostMapping("/trafficViolations")
    public ObjectRestResponse queryTrafficViolations(@RequestBody TrafficViolations trafficViolations) {
        try {
            return ObjectRestResponse.succ(JSONObject.parse(tvService.queryViolations(trafficViolations)));
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 车辆类型查询
     * @return
     */
    @GetMapping("/LicensePlateType")
    public ObjectRestResponse getLicensePlateType() {
        try {
            return ObjectRestResponse.succ(tvService.getLicensePlateType());
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

    @GetMapping("/getRentViolation")
    public ObjectRestResponse<List<ViolationVO>> getRentViolation(RentViolationDTO rentViolationDTO) {
        String vehicleId = rentViolationDTO.getVehicleId();
        if (rentViolationDTO==null||rentViolationDTO.getVehicleId()==null) {
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"Vehicle information is empty");
        }

        Vehicle vehicle = vehicleFeign.get(vehicleId).getData();
        if (vehicle==null) {
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"No corresponding vehicle information");
        }

        return ObjectRestResponse.succ(tvService.getRentViolation(rentViolationDTO,vehicle));
    }


}
