package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.universal.biz.OrderPayBiz;
import com.xxfc.platform.universal.entity.OrderPay;
import com.xxfc.platform.universal.vo.FundPayVo;
import com.xxfc.platform.universal.vo.OrderPayVo;
import com.xxfc.platform.universal.weixin.util.XMLUtil;
import lombok.extern.slf4j.Slf4j;
import org.jdom.JDOMException;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;

@RestController
@RequestMapping("pay")
@Slf4j
public class OrderPayController extends BaseController<OrderPayBiz,OrderPay> {

    /**
     * APP支付
     *
     * @param orderPayVo
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/app/wx", method = RequestMethod.POST) //匹配的是href中的download请求
    public JSONObject wx(@RequestBody OrderPayVo orderPayVo) {
        return baseBiz.preparepay(orderPayVo);
    }


    /**
     * APP支付
     *
     * @param orderPayVo
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/app/unauth", method = RequestMethod.POST) //匹配的是href中的download请求
    public JSONObject app(@RequestBody OrderPayVo orderPayVo) {
        return baseBiz.preparepay(orderPayVo);
    }


    /**
     * 支付回调
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/app/unauth/notify") //匹配的是href中的download请求
    @IgnoreUserToken
    public void notice(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        InputStream inStream = request.getInputStream();
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        String result = new String(outSteam.toByteArray(), "utf-8");

        log.info("---支付回调---result====="+result);
        Map<String, String> map = null;
        try {
            map = XMLUtil.doXMLParse(result);
        } catch (JDOMException e) {
            log.error(e.getMessage(), e);;
        }
        if ("SUCCESS".equals(map.get("return_code")) && "SUCCESS".equals(map.get("result_code"))) {
            try {

                String orderno = map.get("out_trade_no");
                String serialNumber = map.get("transaction_id");
                log.info("---支付回调---orderno====="+orderno+"-----serialNumber====="+serialNumber);
                baseBiz.notice(orderno, serialNumber);
            } catch (Exception e) {
                log.error(e.getMessage(), e);;

            }
            out.print("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[]]></return_msg></xml>");
        } else {
            out.print("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[]]></return_msg></xml>");
        }
    }


    @PostMapping(value = "/app/unauth/notify/alipay")
    @IgnoreUserToken
    public String alipayNotify(){
        return baseBiz.alipayNotify();
    }

    @PostMapping(value = "/app/unauth/notify/fundAuthQuery")
    @IgnoreUserToken
    public ObjectRestResponse fundAuthQuery(String tradNo){
        return baseBiz.fundAuthQuery(tradNo);
    }

    @PostMapping("/app/unauth/transfer_account")
    @IgnoreUserToken
    public ObjectRestResponse<String> transferAccount(@RequestBody FundPayVo fundPayVo){
        try {
            String pay_no = baseBiz.fundTrans(fundPayVo);
            return ObjectRestResponse.succ(pay_no);
        }catch (Exception ex){
            return ObjectRestResponse.createFailedResult(400,ex.getMessage());
        }

    }


}