package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONArray;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.universal.constant.CaptchaType;
import com.xxfc.platform.universal.constant.RedisKey;
import com.xxfc.platform.universal.dto.CaptchaBaseParam;
import com.xxfc.platform.universal.service.AbstractCaptcha;
import com.xxfc.platform.universal.service.CaptchaFactory;
import com.xxfc.platform.universal.service.ICaptchaFactory;
import com.xxfc.platform.universal.utils.ImageUtils;
import com.xxfc.platform.universal.vo.CaptchaBaseVO;
import com.xxfc.platform.universal.vo.ClickWordCaptchaVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.awt.*;
import java.util.concurrent.TimeUnit;

/**
 * 图片验证码
 */
@Controller
@RequestMapping(value = "/captcha")
@Slf4j
public class CaptchaController {

	@Autowired
	RedisTemplate redisTemplate;

    @RequestMapping("/app/unauth/blockPuzzle")
    @ResponseBody
    ObjectRestResponse blockPuzzle() {

        ICaptchaFactory captchaFactory = new CaptchaFactory();
        AbstractCaptcha captcha = captchaFactory.getInstance(CaptchaType.BLOCK_PUZZLE);
        CaptchaBaseParam captchaBaseParam = new CaptchaBaseParam();
        captchaBaseParam.setUrlOrPath(ImageUtils.getBlockPuzzleBgPath());
        captcha.setJigsawUrlOrPath(ImageUtils.getBlockPuzzleJigsawPath());
        CaptchaBaseVO dataVO = captcha.create(captchaBaseParam);
        return ObjectRestResponse.succ(dataVO);
    }

    @RequestMapping("/app/unauth/clickWord")
    @ResponseBody
    ObjectRestResponse clickWord(String phone) {

        ICaptchaFactory captchaFactory = new CaptchaFactory();
        AbstractCaptcha captcha = captchaFactory.getInstance(CaptchaType.CLICK_WORD);
        CaptchaBaseParam captchaBaseParam = new CaptchaBaseParam();
        captchaBaseParam.setUrlOrPath(ImageUtils.getClickWordBgPath());
        captcha.setFontColorRandom(false);
		ClickWordCaptchaVO dataVO = (ClickWordCaptchaVO) captcha.create(captchaBaseParam);
		log.info("获取注册验证码：》》》{}", dataVO.getPointList());
		if (dataVO.getPointList() != null) {
			try {
				String redisLockKey = RedisKey.CAPTCHA_PHONE_PREFIX + phone;
				String captchaCode = redisTemplate.opsForValue().get(redisLockKey) == null ? "" : redisTemplate.opsForValue().get(redisLockKey).toString();
				if (StringUtils.isNotBlank(captchaCode)) {
					redisTemplate.delete(redisLockKey);
				}
				Boolean suc = redisTemplate.opsForValue().setIfAbsent(redisLockKey, JSONArray.toJSONString(dataVO.getPointList()));
				if (suc) {
					redisTemplate.expire(redisLockKey, 5, TimeUnit.MINUTES);//5分钟内过期
					dataVO.setPointList(null);
				}
			} catch (Exception e) {
				log.error(e.getMessage(), e);
				return ObjectRestResponse.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
			}
		}
        return ObjectRestResponse.succ(dataVO);
    }


	@RequestMapping("/app/unauth/verify")
	@ResponseBody
	ObjectRestResponse<Boolean> verify(String phone, String pointList) {
		if (StringUtils.isBlank(phone) || StringUtils.isBlank(pointList)) {
			return ObjectRestResponse.paramIsEmpty();
		}
		String redisLockKey = RedisKey.CAPTCHA_PHONE_PREFIX + phone;
		String captchaCode = redisTemplate.opsForValue().get(redisLockKey) == null ? "" : redisTemplate.opsForValue().get(redisLockKey).toString();
		log.info("【注册验证码坐标】：》》》》》 {}", captchaCode);
		log.info("【注册验证码用户点选坐标】：》》》》》 {}", pointList);
		if (StringUtils.isBlank(captchaCode)) {
			log.error("【注册验证码坐标为空,请重新验证】");
			return ObjectRestResponse.succ(false);
		}
		ICaptchaFactory captchaFactory = new CaptchaFactory();
		AbstractCaptcha captcha = captchaFactory.getInstance(CaptchaType.CLICK_WORD);
		boolean flag = captcha.verification(JSONArray.parseArray(captchaCode, Point.class), JSONArray.parseArray(pointList,Point.class));
		return ObjectRestResponse.succ(flag);
	}

}
