package com.xxfc.platform.universal.fastservice.dto;

import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.net.URLEncoder;

@Data
public class RequestBodyDto {

    private String grantType;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private String code;
    private String redirectUri;
    private String nspSvc;
    private String openId;
    private String accessToken;

    public RequestBodyDto(String grantType, String refreshToken, String clientId, String clientSecret, String code, String redirectUri, String nspSvc, String openId, String accessToken) {
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.nspSvc = nspSvc;
        this.openId = openId;
        this.accessToken = accessToken;
    }

    public RequestBodyDto(String grantType, String clientId, String clientSecret, String code, String redirectUri) {
        this.grantType = grantType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
    }

    public RequestBodyDto(String grantType, String refreshToken, String clientId, String clientSecret) {
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public RequestBodyDto(String nspSvc, String openId, String accessToken) {
        this.nspSvc = nspSvc;
        this.openId = openId;
        this.accessToken = accessToken;
    }

    public String getParamMap(){
        StringBuilder stringBuilder = new StringBuilder();
        if(StringUtils.isNotBlank(this.grantType)) {
            stringBuilder.append("granType = ");
            stringBuilder.append( URLEncoder.encode(this.grantType));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.refreshToken)) {
            stringBuilder.append("refresh_token = ");
            stringBuilder.append( URLEncoder.encode(this.refreshToken));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.clientId)) {
            stringBuilder.append("client_id = ");
            stringBuilder.append( URLEncoder.encode(this.clientId));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.clientSecret)) {
            stringBuilder.append("client_secret = ");
            stringBuilder.append( URLEncoder.encode(this.clientSecret));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.code)) {
            stringBuilder.append("code = ");
            stringBuilder.append( URLEncoder.encode(this.code));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.redirectUri)) {
            stringBuilder.append("redirect_uri = ");
            stringBuilder.append( URLEncoder.encode(this.redirectUri));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.nspSvc)) {
            stringBuilder.append("nsp_svc = ");
            stringBuilder.append( URLEncoder.encode(this.nspSvc));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.openId)) {
            stringBuilder.append("open_id = ");
            stringBuilder.append( URLEncoder.encode(this.openId));
            stringBuilder.append("&");
        }
        if(StringUtils.isNotBlank(this.accessToken)) {
            stringBuilder.append("access_token = ");
            stringBuilder.append( URLEncoder.encode(this.accessToken));
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }
}
