package com.xxfc.platform.summit.controller;


import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.biz.UserBiz;
import com.xxfc.platform.summit.entity.ActivityBm;
import com.xxfc.platform.summit.entity.ActivityTemporary;
import com.xxfc.platform.summit.entity.User;
import com.xxfc.platform.summit.pojo.ActivityBmExcel;
import com.xxfc.platform.summit.pojo.ActivityBmQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activityBm")
@Api(tags = {"峰会报名信息"})
public class ActivityBmController extends BaseController<ActivityBmBiz, ActivityBm> {

    @Autowired
    HttpServletResponse response;
    @Autowired
    UserBiz userBiz;


    @PostMapping("/app/unauth/add")
    public ObjectRestResponse bm(@RequestBody ActivityTemporary activityTemporary) {
        try {
            baseBiz.userBm(activityTemporary);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }

    }


    @PostMapping("/list")
    public ObjectRestResponse getList(@RequestBody ActivityBmQuery query) {
        return ObjectRestResponse.succ(baseBiz.list(query));
    }


    @PostMapping("/excel")
    @ApiOperation("下载报名信息excel表")
    public void getExcel(@RequestBody ActivityBmQuery query) throws Exception {
        List<ActivityBmExcel> rows = baseBiz.excel(query);
        // 通过工具类创建writer，默认创建xls格式
        ExcelWriter writer = ExcelUtil.getWriter();
        writer.addHeaderAlias("name", "姓名");
        writer.addHeaderAlias("phone", "电话");
        writer.addHeaderAlias("idNumber", "身份证号");
        writer.addHeaderAlias("inviter", "邀请人");
        writer.addHeaderAlias("qdStatus", "是否签到");
// 一次性写出内容，使用默认样式，强制输出标题
        writer.write(rows, true);
//out为OutputStream，需要写出到的目标流

//response为HttpServletResponse对象
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
//test.xls是弹出下载对话框的文件名，不能为中文，中文请自行编码
        response.setHeader("Content-Disposition", "attachment;filename=nameList.xls");
        ServletOutputStream out = response.getOutputStream();
        writer.flush(out, true);
// 关闭writer，释放内存
        writer.close();
//此处记得关闭输出Servlet流
        IoUtil.close(out);

    }

}
