package com.xxfc.platform.order.biz;

import cn.hutool.core.util.StrUtil;
import com.xxfc.platform.order.contant.enumerate.OrderLogEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderLog;
import com.xxfc.platform.order.mapper.OrderLogMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

/**
 * 
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-23 17:33:06
 */
@Service
@Slf4j
public class OrderLogBiz extends BaseBiz<OrderLogMapper,OrderLog> {

    public void logChange(Object newObj, Object oldObj, Integer logUserId, String orderNo, OrderLogEnum orderLogEnum) {
        try {
            OrderLog orderLog = new OrderLog(){{
//              setLogUserType();
                setType(orderLogEnum.getCode());
                setLogUserId(logUserId);
                setLogContent(StrUtil.format(orderLogEnum.getContent(), orderNo));
                setDetail(StrUtil.format(orderLogEnum.getDesc(), oldObj, newObj));
            }};

            insertSelectiveRe(orderLog);
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}