package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum OrderLogEnum {
    //账款类型 1--订单常规操作；2--与账相关；3--延期相关
    ORDER_ADD (101, "删除订单"),
    DELAY_MODIFY (301, "延期增改", "订单号:{}, 延期增改", "旧:{}, 新:{}"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    /**
     * 日志内容
     */
    private String content;

    /**
     * 细节
     */
    private String detail;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    OrderLogEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    OrderLogEnum(Integer code, String desc, String content, String detail){
        this.code=code;
        this.desc=desc;
        this.content=content;
        this.detail=detail;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}