package com.xxfc.platform.common.msg;

import lombok.Data;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/9 16:55
 */
@Data
public class ApiResult<T> extends BaseApiResult<T> {

    private ApiResult(long code, String msg, T data, boolean successResponse, String requestId) {
      super(code,msg,data,successResponse,requestId);
    }

    public static <T> ApiResult<T> ok() {
        return new ApiResult(200, "ok", "ok", true, "0");
    }

    public static <T> ApiResult<T> ok(T data) {
        return new ApiResult(200, "ok", data, true, "0");
    }

    public static <T> ApiResult<T> ok(T data, String requestId) {
        return new ApiResult(200, "ok", data, true, requestId);
    }

}
