package com.xxfc.platform.campsite.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.sun.org.apache.regexp.internal.RE;
import com.xxfc.platform.campsite.dto.CampsiteShopFindDTO;
import com.xxfc.platform.campsite.vo.CampsiteShopDetailVo;
import com.xxfc.platform.campsite.vo.CampsiteShopPageVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by ace on 2017/9/15.
 */
//@FeignClient(value = "${auth.serviceId}",configuration = {})
@FeignClient(name = "xx-campsite",path = "/campsiteShop")
public interface CampsiteFeign {

    @ApiOperation("首页营地列表")
    @GetMapping(value = "/app/shopList")
    List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                              @RequestParam(value = "limit", defaultValue = "4") Integer limit);

    @GetMapping(value = "/app/unauth/findRandomVehicle")
    ObjectRestResponse findRandomVehicle(@RequestParam(value = "number") Integer number);

    @ApiOperation("分页查询营地列表")
    @GetMapping("/app/unauth/shops")
    ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsiteShopPageByTypeAndName(@RequestParam(value = "type", required = false) Integer type,
                                                                                         @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "6") Integer pageSize,
                                                                                         @RequestParam(value = "name",required = false) String name);

    /**
     * @param longitude 经度
     * @param latitude  纬度
     * @return
     */
    @ApiOperation("查询营地详情")
    @GetMapping("/app/unauth/shop")
    ObjectRestResponse<CampsiteShopDetailVo> findCampsiteShopDetailById(@RequestParam(value = "id") Integer id,
                                                                        @RequestParam(value = "longitude", required = false) Double longitude,
                                                                        @RequestParam(value = "latitude", required = false) Double latitude);

    @PostMapping(value = "/app/unauth/campsites")
    ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsiteShopPageForUncc(@RequestBody CampsiteShopFindDTO campsiteShopFindDTO);
}
