package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityWinningRecordBiz;
import com.xxfc.platform.activity.bo.ActivityWinningRecordBo;
import com.xxfc.platform.activity.dto.ActivityWinningRecordFindDTO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 16:51
 */
@RestController
@RequestMapping("admin/activityWinningRecord")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityWinningRecordAdminController {

      private final ActivityWinningRecordBiz activityWinningRecordBiz;

      @PostMapping("/page")
      public ObjectRestResponse<ActivityWinningRecordBo> listActivityWinningRecordWithPage(@RequestBody ActivityWinningRecordFindDTO activityLuckDrawFindDTO){
            ActivityWinningRecordBo activityWinningRecordBo =  activityWinningRecordBiz.listActivityWinningRecordWithPage(activityLuckDrawFindDTO);
            return ObjectRestResponse.succ(activityWinningRecordBo);
      }

      @PostMapping("/export")
      public void exportActivityWinningRecordData(@RequestBody ActivityWinningRecordFindDTO activityWinningRecordFindDTO, HttpServletResponse response){
            try {
                  String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
                  response.setContentType("application/vnd.ms-excel;charset=utf-8");
                  String filename = String.format("%s-activity-winnging-record.xlsx",name);
                  response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
                  ServletOutputStream outputStream = response.getOutputStream();
                  activityWinningRecordBiz.exportActivityWinngingData(activityWinningRecordFindDTO,outputStream);
                  response.setCharacterEncoding("UTF-8");
            }catch (Exception ex){
                  throw  new BaseException("导出数据失败");
            }
      }
}