package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.IntegralUserTotalBiz;
import com.xxfc.platform.activity.entity.IntegralUserTotal;
import com.xxfc.platform.activity.vo.IntegralUserTotalDto;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "integralUserTotal")
@Api(value = "用户总积分")
public class IntegralUserTotalController {

    @Autowired
    IntegralUserTotalBiz integralUserTotalBiz;


    @PostMapping(value = "/add")
    public ObjectRestResponse add(IntegralUserTotalDto integralUserTotalDto) {
        return integralUserTotalBiz.add(integralUserTotalDto);
    }

    @PostMapping(value = "/delete")
    public ObjectRestResponse deleteById() {
        return integralUserTotalBiz.deleteOne();
    }

    @GetMapping(value = "/getByUser")
    public ObjectRestResponse getByUser() {
        return integralUserTotalBiz.getByUser();
    }

    @GetMapping(value = "/getAll")
    public ObjectRestResponse getAll(IntegralUserTotalDto integralUserTotalDto) {
        return integralUserTotalBiz.getAll(integralUserTotalDto);
    }

}
