package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.IntegralUserRecordBiz;
import com.xxfc.platform.activity.vo.IntegralUserRecordDto;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "integralUserRecord")
@Api(value = "用户积分记录")
public class IntegralUserRecordController {

    @Autowired
    IntegralUserRecordBiz integralUserRecordBiz;


    @PostMapping(value = "/add")
    public ObjectRestResponse add(IntegralUserRecordDto integralUserRecordDto) {
        return integralUserRecordBiz.add(integralUserRecordDto);
    }

    @PostMapping(value = "/delete")
    public ObjectRestResponse deleteById(Integer id) {
        return integralUserRecordBiz.deleteOne(id);
    }

    @GetMapping(value = "/getListByUser")
    public ObjectRestResponse getByUser(IntegralUserRecordDto integralUserRecordDto) {
        return integralUserRecordBiz.getUserList(integralUserRecordDto);
    }

    @GetMapping(value = "/getListByCode")
    public ObjectRestResponse getListByCode(IntegralUserRecordDto integralUserRecordDto) {
        return integralUserRecordBiz.getByUserAndTime(integralUserRecordDto);
    }


}
