package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityPrizeBiz;
import com.xxfc.platform.activity.entity.ActivityPrize;
import com.xxfc.platform.activity.vo.LotteryVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 19:44
 */
@RestController
@RequestMapping("activityPrize")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityPrizeController {

    private final ActivityPrizeBiz activityPrizeBiz;


    /**
     * 奖品类型获取
     *
     * @param prizeType
     * @return
     */
    @GetMapping("/find_prize")
    public ObjectRestResponse<List<ActivityPrize>> findActivityPrizeByType(@RequestParam(value = "prizeType") Integer prizeType) {
        List<ActivityPrize> activityPrizes = activityPrizeBiz.findActivityPrizeByType(prizeType);
        return ObjectRestResponse.succ(activityPrizes);
    }

    /**
     * 抽奖
     *
     * @param activityId
     * @param appUserDTO
     * @return
     */
    @PostMapping("/lottery/{activityId}/{prizeType}")
    public ObjectRestResponse<LotteryVo> activityLottery(@PathVariable(value = "activityId") Integer activityId,
                                                         @PathVariable(value = "prizeType") Integer prizeType,
                                                         @RequestParam(value = "lottery") String lottery,
                                                         AppUserDTO appUserDTO) {
        LotteryVo lotteryVo = activityPrizeBiz.activityLottery(activityId,prizeType,lottery,appUserDTO);
        return ObjectRestResponse.succ(lotteryVo);
    }

}