package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.google.common.collect.Maps;
import com.xxfc.platform.activity.entity.ActivityPopularizeUser;
import com.xxfc.platform.activity.mapper.ActivityPopularizeUserMapper;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;
import java.util.Map;

/**
 * 用户与推广活动（邀请有礼）的关系表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Service
public class ActivityPopularizeUserBiz extends BaseBiz<ActivityPopularizeUserMapper, ActivityPopularizeUser> {
	public ActivityPopularizeUser insertSelectiveReT(ActivityPopularizeUser entity) {
		if (insertSelectiveRe(entity) > 0) {
			return selectById(entity.getId());
		} else {
			throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
		}
	}

	public void deleteByUserIds(List<Integer> userIds) {
		Example example = new Example(ActivityPopularizeUser.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andIn("userId", userIds);
		mapper.deleteByExample(example);
	}

	public Map<Integer, Boolean> getByUserIdAndPopularizeId(Integer userId, List<Integer> popularizeIds) {
		Map<Integer, Boolean> activityIds = Maps.newHashMap();
		if (userId == null || popularizeIds == null) {
			return activityIds;
		}
        popularizeIds.parallelStream().forEach(id -> {
            Example example = new Example(ActivityPopularizeUser.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("userId", userId);
            criteria.andEqualTo("popularizeId", id);
            ActivityPopularizeUser activityPopularizeUsers = mapper.selectOneByExample(example);
            if (activityPopularizeUsers != null) {
				activityIds.put(id, true);
            } else {
				activityIds.put(id, false);
            }
        });
		return activityIds;
	}
}