package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 通用活动规则表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-16 14:04:22
 */
@Data
@Table(name = "activity_rule")
public class ActivityRule implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  活动名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "活动名称")
    private String name;

	/**
	 *  活动名称
	 */
	@Column(name = "img")
	@ApiModelProperty(value = "活动名称")
	private String img;


	/**
     *  活动描述
     */
    @Column(name = "descr")
	@ApiModelProperty(value = "活动描述")
    private String descr;
	
	    /**
     *  活动人数限制
     */
    @Column(name = "number")
	@ApiModelProperty(value = "活动人数限制")
    private Integer number;
	
	    /**
     *  参加活动人数
     */
    @Column(name = "join_number")
	@ApiModelProperty(value = "参加活动人数")
    private Integer joinNumber;
	
	    /**
     *  活动是否开启：0-未开启；1-已开启;2-已关闭
     */
    @Column(name = "status")
	@ApiModelProperty(value = "活动是否开启：0-未开启；1-已开启;2-已关闭")
    private Integer status;
	
	    /**
     *  活动奖励规则,json数组格式 [{"type":1, "detail":{...}},...] //// type分类 1--现金；
     */
    @Column(name = "value")
	@ApiModelProperty(value = "活动奖励规则,json数组格式 [{type:1, detail:{...}},...] //// type分类 1--现金；")
    private String value;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
