package com.github.wxiaoqi.security.admin.mapper;

import com.github.wxiaoqi.security.admin.bo.UserBo;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 用户关系表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-03 16:36:44
 */
public interface AppUserRelationMapper extends Mapper<AppUserRelation> {


    List<AppUserRelation> selectByLeaderId(Integer leaderId);

    //获取有效的下级
    public  int countByParentId(@Param("parentId")Integer parentId,@Param("bindTime")Long bindTime);

    List<AppUserRelation> selectByUserIds(@Param("userIds") List<Integer> userIds);

    List<AppUserRelation> selectCountByLeaderId(Integer userId);

    List<UserBo> findAllRelations();

    void updateParentIdByUserId(@Param("leaderId") Integer leaderId,@Param("userId") Integer userId,@Param("updTime") Long updTime);
}
