package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.AppShareholderDetailChangeRecordDTO;
import com.github.wxiaoqi.security.admin.dto.AppShareholderDetailDTO;
import com.github.wxiaoqi.security.admin.entity.AppShareholderDetail;
import com.github.wxiaoqi.security.admin.entity.AppShareholderDetailChangeRecord;
import com.github.wxiaoqi.security.admin.mapper.AppShareholderDetailChangeRecordMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.apache.commons.beanutils.BeanUtils;
import tk.mybatis.mapper.entity.Example;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Transactional
@Service("appShareholderDetailChangeRecordBiz")
public class AppShareholderDetailChangeRecordBiz extends BaseBiz<AppShareholderDetailChangeRecordMapper, AppShareholderDetailChangeRecord> {
    /**
     * 股东变变更记录插入
     */
    public void addAppShareholderDetailChangeRecord(AppShareholderDetail appShareholderDetail, Integer operatorId, Integer changeState) {
        AppShareholderDetailChangeRecord appShareholderDetailChangeRecord = new AppShareholderDetailChangeRecord();
        appShareholderDetailChangeRecord.setRelTime(appShareholderDetail.getRelTime());
        appShareholderDetailChangeRecord.setName(appShareholderDetail.getName());
        appShareholderDetailChangeRecord.setPhone(appShareholderDetail.getPhone());
        appShareholderDetailChangeRecord.setCompanyId(appShareholderDetail.getCompanyId());
        appShareholderDetailChangeRecord.setCompanyName(appShareholderDetail.getCompanyName());
        appShareholderDetailChangeRecord.setOperatorId(operatorId);
        appShareholderDetailChangeRecord.setIsQuit(changeState);
        appShareholderDetailChangeRecord.setUserId(appShareholderDetail.getId());
        appShareholderDetailChangeRecord.setCrtTime(System.currentTimeMillis());
        mapper.insertSelective(appShareholderDetailChangeRecord);
    }

    /**
     * 查询员工信息变更记录表
     */
    public List<AppShareholderDetailChangeRecord> findShareholderChangeRecord(AppShareholderDetail appShareholderDetail) {
        Example example = new Example(AppShareholderDetailChangeRecord.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", appShareholderDetail.getId());
        if (appShareholderDetail.getPhone() != null) {
            criteria.andEqualTo("phone", appShareholderDetail.getPhone());
        }
        List<AppShareholderDetailChangeRecord > list = mapper.selectByExample(example);
        return list;
    }
}
