package com.github.wxiaoqi.security.admin.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 10:45
 */
@Data
public class WalletCathVo {

     private Long id;
    /**
     *  用户iD
     */
    @ApiModelProperty(value = "用户iD")
    private String userId;

    /**
     *  提现类别，第三方提现类别(0-微信，1-支付宝，2-银行卡)
     */
    @ApiModelProperty(value = "提现类别，第三方提现类别(0-微信，1-支付宝，2-银行卡)")
    private Integer cathType;

    /**
     *  商户订单号
     */
    @ApiModelProperty(value = "商户订单号")
    private String orderno;

    /**
     *  第三方订单号：如微信，支付宝，银行卡等
     */
    @ApiModelProperty(value = "第三方订单号：如微信，支付宝，银行卡等")
    private String cono;

    /**
     *  提现金额
     */
    @ApiModelProperty(value = "提现金额")
    private BigDecimal amount;

    /**
     *  订单状态：0-未提现,待审核，1-已审核
     */
    @ApiModelProperty(value = "订单状态：0-未提现,待审核，1-已审核")
    private Integer stauts;

    /**
     *  提现日期
     */
    @ApiModelProperty(value = "提现日期", hidden = true )
    private Long crtTime;

    /**
     *  审核日期
     */
    @ApiModelProperty(value = "审核日期")
    private Long finishTime;

    @ApiModelProperty(value = "用户账号描述")
    private String accountNumberDesc;

    private String accountName;

}
