package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 用户身份职位临时表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Data
@Table(name = "app_user_position_temp")
public class AppUserPositionTemp implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	

    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;


    @Column(name = "phone")
	@ApiModelProperty(value = "手机号码")
    private String phone;
	

    @Column(name = "position_id")
	@ApiModelProperty(value = "职位id")
    private Integer positionId;

    @Column(name = "job_id")
    @ApiModelProperty(value = "员工职位id")
    private Integer jobId;


    @Column(name = "company_id")
    @ApiModelProperty(value = "分公司id")
    private Integer companyId;

    @Column(name = "company_name")
    @ApiModelProperty(value = "分公司名称")
    private String companyName;

	@Column(name = "name")
	@ApiModelProperty(value = "姓名")
	private String name;


    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
    @ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	

    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;

    @Column(name = "is_quit")
    @ApiModelProperty(value = "员工职位状态：0-正常；1-离职")
    private Integer isQuit;


}
