package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.Arrays;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 员工变更状态
 * @data 2019/12/21 18:14
 */
public enum StaffChangeStatusEnum {
    INDUCTION(1, "入职"),
    JOB_CHANGE(2, "职位变更"),
    IDENTITY_CHANE(3, "身份变更"),
    COMPANY_CHANGE(4, "公司所属变更"),
    JOB_SEPARATION(5, "离职(状态更改)"),
    REINSTATED(6, "复职(状态更改)");

    private int code;
    private String desc;
    public static List<Integer> needChangePostionsStatus;
    static {
        needChangePostionsStatus = Arrays.asList(INDUCTION.getCode(),IDENTITY_CHANE.getCode(),JOB_SEPARATION.getCode(),REINSTATED.getCode());
    }

    StaffChangeStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
