package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.Arrays;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 身份等级
 * @data 2019/12/21 16:51
 */
public enum IdentityLevel {
    HEADQUARTERS_SHAREHOLDER(1, "总部股东"),
    BRANCH_SHAREHOLDER(2, "分公司股东"),
    PARTNER(3, "合伙人"),
    STAFF(4, "员工"),
    DEPUTY(5, "代理人"),
    COMMON_USER(0, "普通用户");

    private int level;
    private String name;
    /**
     * 股东
     */
    private static List<Integer> shareholeders;
    /**
     * 员工
     */
    private static List<Integer> employees;

    static {
        shareholeders = Arrays.asList(HEADQUARTERS_SHAREHOLDER.getLevel(), BRANCH_SHAREHOLDER.getLevel());
        employees = Arrays.asList(PARTNER.getLevel(), STAFF.getLevel(), DEPUTY.getLevel(), COMMON_USER.getLevel());
    }

    IdentityLevel(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
