package com.github.wxiaoqi.security.common.mapper;

import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import tk.mybatis.mapper.common.Mapper;

public interface VersionMapper<T> extends Mapper<T> {
    default int deleteWithVersion(T t) {
        int result = delete(t);
        if(result == 0) {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
        return result;
    }

    default int updateByPrimaryKeyWithVersion(T t){
        int result = updateByPrimaryKey(t);
        if(result == 0) {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
        return result;
    }
}
