/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.alibaba.csp.sentinel.util.courier.StringUtils;
import com.taobao.csp.sentinel.dashboard.datasource.entity.RuleEntity;
import com.taobao.csp.sentinel.dashboard.datasource.entity.SystemRuleEntity;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.inmem.HttpHelper;
import com.taobao.csp.sentinel.dashboard.inmem.InMemSystemRuleStore;
import com.taobao.csp.sentinel.dashboard.view.Result;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"}, produces={"application/json"})
public class SystemController {
    private static Logger logger = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private InMemSystemRuleStore repository;
    @Autowired
    private HttpHelper httpHelper;

    @ResponseBody
    @RequestMapping(value={"/rules.json"})
    Result<List<SystemRuleEntity>> queryMachineRules(String app, String ip, Integer port) {
        if (StringUtils.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtils.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        try {
            List rules = this.httpHelper.fetchSystemRuleOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            logger.error("queryApps error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    private int countNotNullAndNotNegtive(Number ... values) {
        int notNullCount = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i].doubleValue() >= 0.0)) continue;
            ++notNullCount;
        }
        return notNullCount;
    }

    @ResponseBody
    @RequestMapping(value={"/new.json"})
    Result<?> add(String app, String ip, Integer port, Double avgLoad, Long avgRt, Long maxThread, Double qps) {
        if (StringUtils.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtils.isBlank((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        int notNullCount = this.countNotNullAndNotNegtive(new Number[]{avgLoad, avgRt, maxThread, qps});
        if (notNullCount != 1) {
            return Result.ofFail((int)-1, (String)("only one of [avgLoad, avgRt, maxThread, qps] value must be set >= 0, but " + notNullCount + " values get"));
        }
        SystemRuleEntity entity = new SystemRuleEntity();
        entity.setApp(app.trim());
        entity.setIp(ip.trim());
        entity.setPort(port);
        if (avgLoad != null) {
            entity.setAvgLoad(avgLoad);
        } else {
            entity.setAvgLoad(Double.valueOf(-1.0));
        }
        if (avgRt != null) {
            entity.setAvgRt(avgRt);
        } else {
            entity.setAvgRt(Long.valueOf(-1L));
        }
        if (maxThread != null) {
            entity.setMaxThread(maxThread);
        } else {
            entity.setMaxThread(Long.valueOf(-1L));
        }
        if (qps != null) {
            entity.setQps(qps);
        } else {
            entity.setQps(Double.valueOf(-1.0));
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (SystemRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            logger.error("add error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, ip, port)) {
            logger.info("publish system rules fail after rule add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/save.json"})
    Result<?> updateIfNotNull(Long id, String app, Double avgLoad, Long avgRt, Long maxThread, Double qps) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        SystemRuleEntity entity = (SystemRuleEntity)this.repository.findById(id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " dose not exist"));
        }
        if (StringUtils.isNotBlank((String)app)) {
            entity.setApp(app.trim());
        }
        if (avgLoad != null) {
            if (avgLoad < 0.0) {
                return Result.ofFail((int)-1, (String)"avgLoad must >= 0");
            }
            entity.setAvgLoad(avgLoad);
        }
        if (avgRt != null) {
            if (avgRt < 0L) {
                return Result.ofFail((int)-1, (String)"avgRt must >= 0");
            }
            entity.setAvgRt(avgRt);
        }
        if (maxThread != null) {
            if (maxThread < 0L) {
                return Result.ofFail((int)-1, (String)"maxThread must >= 0");
            }
            entity.setMaxThread(maxThread);
        }
        if (qps != null) {
            if (qps < 0.0) {
                return Result.ofFail((int)-1, (String)"qps must >= 0");
            }
            entity.setQps(qps);
        }
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (SystemRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            logger.error("save error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            logger.info("publish system rules fail after rule update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/delete.json"})
    Result<?> delete(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        SystemRuleEntity oldEntity = (SystemRuleEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Throwable throwable) {
            logger.error("delete error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            logger.info("publish system rules fail after rule delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.httpHelper.setSystemRuleOfMachine(app, ip, port.intValue(), rules);
    }
}

