/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.alibaba.csp.sentinel.util.courier.StringUtils;
import com.taobao.csp.sentinel.dashboard.datasource.entity.FlowRuleEntity;
import com.taobao.csp.sentinel.dashboard.datasource.entity.RuleEntity;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.inmem.HttpHelper;
import com.taobao.csp.sentinel.dashboard.inmem.InMemFlowRuleStore;
import com.taobao.csp.sentinel.dashboard.view.Result;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/flow"}, produces={"application/json"})
public class FlowController {
    private static Logger logger = LoggerFactory.getLogger(FlowController.class);
    @Autowired
    private InMemFlowRuleStore repository;
    @Autowired
    private HttpHelper httpHelper;

    @ResponseBody
    @RequestMapping(value={"/rules.json"})
    Result<List<FlowRuleEntity>> queryMachineRules(String app, String ip, Integer port) {
        if (StringUtils.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtils.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        try {
            List rules = this.httpHelper.fetchFlowRuleOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            logger.error("queryApps error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/new.json"})
    Result<?> add(String app, String ip, Integer port, String limitApp, String resource, Integer grade, Double count, Integer strategy, String refResource, Integer controlBehavior, Integer warmUpPeriodSec, Integer maxQueueingTimeMs) {
        if (StringUtils.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtils.isBlank((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (StringUtils.isBlank((String)limitApp)) {
            return Result.ofFail((int)-1, (String)"limitApp can't be null or empty");
        }
        if (StringUtils.isBlank((String)resource)) {
            return Result.ofFail((int)-1, (String)"resource can't be null or empty");
        }
        if (grade == null) {
            return Result.ofFail((int)-1, (String)"grade can't be null");
        }
        if (grade != 0 && grade != 1) {
            return Result.ofFail((int)-1, (String)("grade must be 0 or 1, but " + grade + " got"));
        }
        if (count == null) {
            return Result.ofFail((int)-1, (String)"count can't be null");
        }
        if (strategy == null) {
            return Result.ofFail((int)-1, (String)"strategy can't be null");
        }
        if (strategy != 0 && StringUtils.isBlank((String)refResource)) {
            return Result.ofFail((int)-1, (String)"refResource can't be null or empty when strategy!=0");
        }
        if (controlBehavior == null) {
            return Result.ofFail((int)-1, (String)"controlBehavior can't be null");
        }
        if (controlBehavior == 1 && warmUpPeriodSec == null) {
            return Result.ofFail((int)-1, (String)"warmUpPeriodSec can't be null when controlBehavior==1");
        }
        if (controlBehavior == 2 && maxQueueingTimeMs == null) {
            return Result.ofFail((int)-1, (String)"maxQueueingTimeMs can't be null when controlBehavior==2");
        }
        FlowRuleEntity entity = new FlowRuleEntity();
        entity.setApp(app.trim());
        entity.setIp(ip.trim());
        entity.setPort(port);
        entity.setLimitApp(limitApp.trim());
        entity.setResource(resource.trim());
        entity.setGrade(grade);
        entity.setCount(count);
        entity.setStrategy(strategy);
        entity.setControlBehavior(controlBehavior);
        entity.setWarmUpPeriodSec(warmUpPeriodSec);
        entity.setMaxQueueingTimeMs(maxQueueingTimeMs);
        if (strategy != 0) {
            entity.setRefResource(refResource.trim());
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (FlowRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            logger.error("add error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, ip, port)) {
            logger.info("publish flow rules fail after rule add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/save.json"})
    Result<?> updateIfNotNull(Long id, String app, String limitApp, String resource, Integer grade, Double count, Integer strategy, String refResource, Integer controlBehavior, Integer warmUpPeriodSec, Integer maxQueueingTimeMs) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        FlowRuleEntity entity = (FlowRuleEntity)this.repository.findById(id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " dose not exist"));
        }
        if (StringUtils.isNotBlank((String)app)) {
            entity.setApp(app.trim());
        }
        if (StringUtils.isNotBlank((String)limitApp)) {
            entity.setLimitApp(limitApp.trim());
        }
        if (StringUtils.isNotBlank((String)resource)) {
            entity.setResource(resource.trim());
        }
        if (grade != null) {
            if (grade != 0 && grade != 1) {
                return Result.ofFail((int)-1, (String)("grade must be 0 or 1, but " + grade + " got"));
            }
            entity.setGrade(grade);
        }
        if (count != null) {
            entity.setCount(count);
        }
        if (strategy != null) {
            if (strategy != 0 && strategy != 1 && strategy != 2) {
                return Result.ofFail((int)-1, (String)("strategy must be in [0, 1, 2], but " + strategy + " got"));
            }
            entity.setStrategy(strategy);
            if (strategy != 0) {
                if (StringUtils.isBlank((String)refResource)) {
                    return Result.ofFail((int)-1, (String)"refResource can't be null or empty when strategy!=0");
                }
                entity.setRefResource(refResource.trim());
            }
        }
        if (controlBehavior != null) {
            if (controlBehavior != 0 && controlBehavior != 1 && controlBehavior != 2) {
                return Result.ofFail((int)-1, (String)("controlBehavior must be in [0, 1, 2], but " + controlBehavior + " got"));
            }
            if (controlBehavior == 1 && warmUpPeriodSec == null) {
                return Result.ofFail((int)-1, (String)"warmUpPeriodSec can't be null when controlBehavior==1");
            }
            if (controlBehavior == 2 && maxQueueingTimeMs == null) {
                return Result.ofFail((int)-1, (String)"maxQueueingTimeMs can't be null when controlBehavior==2");
            }
            entity.setControlBehavior(controlBehavior);
            if (warmUpPeriodSec != null) {
                entity.setWarmUpPeriodSec(warmUpPeriodSec);
            }
            if (maxQueueingTimeMs != null) {
                entity.setMaxQueueingTimeMs(maxQueueingTimeMs);
            }
        }
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (FlowRuleEntity)this.repository.save((RuleEntity)entity);
            if (entity == null) {
                return Result.ofFail((int)-1, (String)"save entity fail");
            }
        }
        catch (Throwable throwable) {
            logger.error("save error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            logger.info("publish flow rules fail after rule update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/delete.json"})
    Result<?> delete(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        FlowRuleEntity oldEntity = (FlowRuleEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Exception e) {
            return Result.ofFail((int)-1, (String)e.getMessage());
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            logger.info("publish flow rules fail after rule delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.httpHelper.setFlowRuleOfMachine(app, ip, port.intValue(), rules);
    }
}

