package com.xxfc.platform.vehicle.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.RedisKey;
import com.xxfc.platform.vehicle.entity.AccompanyingItem;
import com.xxfc.platform.vehicle.mapper.AccompanyingItemMapper;
import com.xxfc.platform.vehicle.pojo.AddOrUpdateAccompanyingItem;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.pojo.QueryAccompanyItemVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class AccompanyingItemBiz extends BaseBiz<AccompanyingItemMapper, AccompanyingItem> {



    @Cache(key = RedisKey.ACCOMPANYING_ITEM_CACHE_ALL)
    public List<AccompanyingItem> getAll(){
        return mapper.selectAll();
    }

    /**
     * 按id获取列表，没有缓存
     * @param id
     * @return
     */
    public AccompanyingItem get(Integer id){
        return mapper.selectByPrimaryKey(id);
    }

    /**
     * 按id获取列表，没有缓存
     * @param ids
     * @return
     */
    public List<AccompanyingItem> getByIds(List<Integer> ids){
        return mapper.getByIdList(ids);
    }

    /**
     * 按页查询，
     * 注意，此处一共名称的模糊查询是预测其数据量较少，有变化后考虑加入全文索引
     * @param queryAccompanyItemVo
     * @return
     * @throws Exception
     */
    public PageDataVO<AccompanyingItem> getByPage(QueryAccompanyItemVo queryAccompanyItemVo) throws Exception{
        Map<String,String> params = BeanUtils.describe(queryAccompanyItemVo);
        PageHelper.startPage(queryAccompanyItemVo.getPage(),queryAccompanyItemVo.getLimit());
        List<AccompanyingItem> accompanyingItems = mapper.getAllByPage(params);
        PageInfo<AccompanyingItem> accompanyingItemsPageInfo = new PageInfo<>(accompanyingItems);
        return PageDataVO.pageInfo(accompanyingItemsPageInfo);
    }

    @CacheClear(key= RedisKey.ACCOMPANYING_ITEM_CACHE_ALL)
    public RestResponse<Integer> add( AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        AccompanyingItem accompanyingItem = new AccompanyingItem();
        accompanyingItem.setId(null);
        BeanUtils.copyProperties(accompanyingItem,addOrUpdateAccompanyingItem);
        Integer effected = mapper.insertSelective(accompanyingItem);
        return RestResponse.suc();
    }

    @CacheClear(key= RedisKey.ACCOMPANYING_ITEM_CACHE_ALL)
    public RestResponse<Integer> update( AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        AccompanyingItem accompanyingItem = new AccompanyingItem();
        BeanUtils.copyProperties(accompanyingItem,addOrUpdateAccompanyingItem);
        Integer effected = mapper.updateByPrimaryKeySelective(accompanyingItem);
        return RestResponse.suc();
    }

    @CacheClear(key= RedisKey.ACCOMPANYING_ITEM_CACHE_ALL)
    public RestResponse<Integer> del(Integer id){
        Integer effected = mapper.deleteByPrimaryKey(id);
        return RestResponse.suc();
    }
}
