package com.xxfc.platform.vehicle;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi.security.common.handler",
        "com.github.wxiaoqi.security.common.log"
})
//@ComponentScan(basePackages={"com.xxfc.platform.vehicle.rest"})
@EnableDiscoveryClient
@EnableScheduling
@EnableAceAuthClient
@EnableFeignClients(value = {"com.github.wxiaoqi.security","com.xxfc.platform.vehicle.feign"},defaultConfiguration = HeaderConfig.class)
@EnableAceCache
@tk.mybatis.spring.annotation.MapperScan(basePackages = "com.xxfc.platform.vehicle.mapper")
public class VehicleApplication {

    public static void main(String[] args) {
        SpringApplication.run(VehicleApplication.class, args);
    }


}
