DROP TABLE IF EXISTS `member_info`;
CREATE TABLE `member_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(10) NOT NULL COMMENT '姓名',
  `sex` tinyint(1) NOT NULL COMMENT '性别(0:男,1:女)',
  `card_number` varchar(50) DEFAULT NULL COMMENT '卡号',
  `birthday` datetime DEFAULT NULL COMMENT '生日',
  `id_number` varchar(20) DEFAULT NULL COMMENT '身份证号',
  `certificate_address` varchar(100) DEFAULT NULL COMMENT '证件地址',
  `email` varchar(100) DEFAULT NULL COMMENT '电子邮件',
  `wx` varchar(100) DEFAULT NULL COMMENT '微信',
  `member_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '会员类型(0:会员,1:VIP会员,2:砖石会员)',
  `telephone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `mobile_phone` varchar(20) DEFAULT NULL COMMENT '手机',
  `address` varchar(255) DEFAULT NULL COMMENT '常住地址',
  `workplace` varchar(255) DEFAULT NULL COMMENT '工作单位',
  `job` varchar(100) DEFAULT NULL COMMENT '职务',
  `inviter` varchar(100) DEFAULT NULL COMMENT '邀约人',
  `profession` varchar(20) DEFAULT NULL COMMENT '职业',
  `pay_type` tinyint(4) DEFAULT NULL COMMENT '支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)',
  `member_signature_date` datetime DEFAULT NULL COMMENT '会员签名日期',
  `manager` varchar(20) DEFAULT NULL COMMENT '经理',
  `manager_signature_date` datetime DEFAULT NULL COMMENT '经理签名日期',
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `create_user_id` int NOT NULL COMMENT '创建人用户id',
  `create_user_name` varchar(50) NOT NULL COMMENT '创建人姓名',
  `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '会员状态(-1:停用,0:未审核,1:正常)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `member_family_info`;
CREATE TABLE `member_family_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `name` varchar(10) NOT NULL COMMENT '姓名',
  `relationship` varchar(10) NOT NULL COMMENT '关系',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;