package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.tour.biz.TourGoodDetailBiz;
import com.xxfc.platform.tour.entity.TourGood;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("good")
@IgnoreClientToken
public class TourGoodDetailController{


    @Autowired
    TourGoodDetailBiz detailBiz;


     //获取商品详情
    @RequestMapping(value = "/app/unauth/details", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse details(@RequestParam(value = "goodId",defaultValue = "0") Integer goodId) {
        return detailBiz.getGoodDetaileById(goodId);
    }

    //获取商品信息
    @RequestMapping(value = "/app/unauth/one", method = RequestMethod.GET)
    @IgnoreUserToken
    public TourGood one(@RequestParam(value = "goodId",defaultValue = "0") Integer goodId) {
        return detailBiz.getOneGood(goodId);
    }





}