package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-23 17:33:06
 */
@Data
@Table(name = "order_log")
public class OrderLog implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  日志id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("日志id")
    private Integer id;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  对应的订单状态
     */
    @Column(name = "order_status")
	@ApiModelProperty(value = "对应的订单状态")
    private Integer orderStatus;
	
	    /**
     *  操作日志
     */
    @Column(name = "log_content")
	@ApiModelProperty(value = "操作日志")
    private String logContent;
	
	    /**
     *  操作者id，另外 -1为系统
     */
    @Column(name = "log_user_id")
	@ApiModelProperty(value = "操作者id，另外 -1为系统")
    private Integer logUserId;
	
	    /**
     *  操作者类型
     */
    @Column(name = "log_user_type")
	@ApiModelProperty(value = "操作者类型")
    private Integer logUserType;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  日志类型 11--创建订单；12--创建订单；
     */
    @Column(name = "type")
	@ApiModelProperty(value = "日志类型 11--创建订单；12--创建订单；")
    private Integer type;
	

}
