package com.xxfc.platform.common.config;

import io.swagger.annotations.Api;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 通用swagger设置
 * @data 2019/6/26 10:28
 */
@Profile(value = {"dev","test"})
@ConditionalOnClass(value = EnableSwagger2.class)
@ConditionalOnProperty(prefix = "xxfc",name = "swagger",havingValue = "true")
@EnableSwagger2
@Setter
public class SwaggerConfig {

      @Value("${xxfc.swagger.title:xxfc api swagger document}")
      private String title;

      @Value("${xxfc.swagger.description:前后端联调xxfc api 文档}")
      private String description;

      @Value("${xxfc.swagger.version:1.0.0}")
      private String version;

      @Value("${jwt.tokenHeader:Authorization}")
     private String  header;

     @Bean
     public Docket docket(){

         ParameterBuilder ticketPar = new ParameterBuilder();
         List<Parameter> parameters = new ArrayList<Parameter>();
         ticketPar.name(header).description("user Authorization")
                 .modelRef(new ModelRef("string")).parameterType("header")
                 //header中的ticket参数非必填，传空也可以
                 .required(false).build();
         //根据每个方法名也知道当前方法在设置什么参数
         parameters.add(ticketPar.build());

         return new Docket(DocumentationType.SWAGGER_2)
                 .apiInfo(apiInfo())
                 .select()
                 .apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
                 .paths(PathSelectors.any())
                 .build()
                 .globalOperationParameters(parameters);
     }

     private ApiInfo apiInfo(){
         return new ApiInfoBuilder()
                 .title(title)
                 .description(description)
                 .version(version)
                 .build();
     }
}
