package com.xxfc.platform.campsite.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.sun.org.apache.regexp.internal.RE;
import com.xxfc.platform.campsite.biz.CampsiteShopBiz;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import com.xxfc.platform.campsite.vo.CampsiteShopDetailVo;
import com.xxfc.platform.campsite.vo.CampsiteShopPageVo;
import com.xxfc.platform.campsite.vo.CampsiteShopVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description 营地店铺
 * @data 2019/6/17 13:37
 */
@RestController
@RequestMapping("/campsiteShop")
@Api(tags = "App营地店铺")
public class CampsiteShopController extends BaseController<CampsiteShopBiz, CampsiteShop> {


    @ApiOperation("分页查询营地列表")
    @GetMapping("/app/unauth/shops")
    public ObjectRestResponse<PageDataVO<CampsiteShopVo>> findCampsiteShopPageByType(@RequestParam(value = "type", required = false) Integer type,
                                                                                     @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                                     @RequestParam(value = "pageSize", required = false, defaultValue = "6") Integer pageSize) {
        PageDataVO<CampsiteShopPageVo> pageDataVO = getBaseBiz().findCampsiteShopPageByType(type, pageNo, pageSize);
        return ObjectRestResponse.succ(pageDataVO);
    }


    /**
     * @param longitude 经度
     * @param latitude  纬度
     * @return
     */
    @ApiOperation("查询营地详情")
    @GetMapping("/app/unauth/shop")
    public ObjectRestResponse<CampsiteShopDetailVo> findCampsiteShopDetailById(@RequestParam("id") Integer id, @RequestParam("longitude") Double longitude, @RequestParam("latitude") Double latitude) {
        CampsiteShopDetailVo campsiteShopDetailVo = getBaseBiz().findCampsiteShopDetailById(id, longitude, latitude);
        return ObjectRestResponse.succ(campsiteShopDetailVo);
    }

    @ApiOperation("首页营地列表")
    @GetMapping(value = "/app/shopList")
    public List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit",defaultValue = "4") Integer limit) {
        return getBaseBiz().getAllByHome(page,limit);
    }


}