package com.github.wxiaoqi.security.admin.mapper;

import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public interface AppUserLoginMapper extends Mapper<AppUserLogin>, SelectByIdListMapper<AppUserLogin,Integer> {


    /**
     * 登录信息更改 ip 登录时间
     * @param userId
     * @param ip
     * @param lastTime
     */
    @Update("update `app_user_login` set `last_host`=#{ip},`last_time`=#{lastTime} where `id`=#{userId}")
    void updateLoginUserInfoById(@Param("userId") Integer userId,@Param("ip") String ip, @Param("lastTime") long lastTime);

    List<AppUserLogin> selectbyPhones(@Param("phones") List<String> phones);
}