package com.github.wxiaoqi.security.gate;

import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import com.github.wxiaoqi.security.gate.utils.DBLog;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author ace
 * @create 2018/3/12.
 */
//@SpringBootApplication
@SpringCloudApplication
@EnableDiscoveryClient
@EnableAceAuthClient
@EnableFeignClients(value = {"com.github.wxiaoqi.security.auth.client.feign","com.github.wxiaoqi.security.gate.feign"},defaultConfiguration = HeaderConfig.class)
public class GatewayServerBootstrap {
    public static void main(String[] args) {
        DBLog.getInstance().start();
        SpringApplication.run(GatewayServerBootstrap.class, args);
    }
}
