import cn.hutool.core.date.DateUtil;
import com.xxfc.platform.order.OrderApplication;
import com.xxfc.platform.order.biz.*;
import com.xxfc.platform.order.jobhandler.BaseOrderStatisticsJobHandler;
import com.xxfc.platform.order.jobhandler.OrderReceivedStatisticsJobHandler;
import com.xxfc.platform.order.pojo.HomePageOrderData;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.SneakyThrows;
import org.joda.time.DateTime;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/6 20:05
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {OrderApplication.class})
public class ServiceTest {

    @Autowired
    private DailyOrderStatisticsBiz dailyOrderStatisticsBiz;

    @Autowired
    private OrderStatisticsBiz statisticsBiz;

    @Autowired
    private BaseOrderStatisticsJobHandler handler;

    @Autowired
    private OrderMemberReceivedStatisticsBiz orderMemberReceivedStatisticsBiz;

    @Autowired
    private OrderRentVehicleReceivedStatisticsBiz orderRentVehicleReceivedStatisticsBiz;

    @Autowired
    private OrderReceivedStatisticsJobHandler orderReceivedStatisticsJobHandler;
    @Autowired
    private OrderTourReceivedStatisticsBiz orderTourReceivedStatisticsBiz;
    @Autowired
    private VehicleFeign vehicleFeign;
    @Test
    public void testSchedu(){

        dailyOrderStatisticsBiz.statisticalOrder(1);
    }

    @Test
    public void test() throws  ParseException {
        String d="2019-09-01";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = dateFormat.parse(d);
        System.out.println(parse);
    }

    @Test
    public void test2()  {
        DateTime dateTime = DateTime.parse("2019-10-10");
        System.out.println(dateTime);
    }

    @Test
    public void test3()  {
        DateTime dateTime = DateTime.parse("2019-10-10");
        Date date = dateTime.toDate();
        DateTime dateTime1 = DateTime.parse("2019-12-10");
        Date date1 = dateTime1.toDate();
        System.out.println(date);
        System.out.println(date1);
        System.out.println(date.before(date1));
        System.out.println(date.after(date1));
    }

    @Test
    public void test4(){
        HomePageOrderData totalOrder = statisticsBiz.getTotalOrder(null,null);
        System.out.println(totalOrder);

    }

    @Test
    public void handlerTeset()  {
        handler.execute("2019-09-29");
    }

    @Test
    public void testMemberStatistics(){
        Date date = DateTime.parse("2019-11-15").toDate();
        Date startDate = DateUtil.beginOfDay(date).toJdkDate();
        Date endDate = DateUtil.endOfDay(date).toJdkDate();
        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();
        orderMemberReceivedStatisticsBiz.orderMemberReceivedStatistics(startDate,endDate,companyMap);
    }

    @Test
    public void testRentVehicleStatistics(){
        Date date = DateTime.parse("2019-11-15").toDate();
        Date startDate = DateUtil.beginOfDay(date).toJdkDate();
        Date endDate = DateUtil.endOfDay(date).toJdkDate();
        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();
        orderRentVehicleReceivedStatisticsBiz.orderRentVehicleReceivedStatistics(startDate,endDate,companyMap);
    }

    @Test
    public void testTourStatistics(){
        Date date = DateTime.parse("2019-11-15").toDate();
        Date startDate = DateUtil.beginOfDay(date).toJdkDate();
        Date endDate = DateUtil.endOfDay(date).toJdkDate();
        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();
        orderTourReceivedStatisticsBiz.orderTourInsertStatisticsNew(startDate,endDate,companyMap);
    }

    @Test
    @SneakyThrows
    public void testOrderReceivedStatisticsJobHandler(){
        cn.hutool.core.date.DateTime dateTime = DateUtil.parse("2019-11-29", "yyyy-MM-dd");
     //   cn.hutool.core.date.DateTime offset = DateUtil.offset(dateTime, DateField.DAY_OF_MONTH, 1);
        orderReceivedStatisticsJobHandler.execute("2019-11-15");
      /*  LocalDate startLocalDate = LocalDate.of(2019, 10, 01);
        LocalDate endLocalDate = LocalDate.of(2019,12,19);
        while (startLocalDate.isBefore(endLocalDate)){
            String dateStr = startLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            startLocalDate = startLocalDate.plusDays(1);
            orderReceivedStatisticsJobHandler.execute(dateStr);
        }*/
    }
}
