package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户临时关系绑定表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-03 16:36:44
 */
@Data
@Table(name = "app_user_relation_temp")
public class AppUserRelationTemp implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  别的服务（比如小程序）用户id
     */
    @Column(name = "temp_id")
	@ApiModelProperty(value = "别的服务（比如小程序）用户id")
    private Integer tempId;
	
	    /**
     *  类型：1-小程序
     */
    @Column(name = "type")
	@ApiModelProperty(value = "类型：1-小程序")
    private Integer type;
	
	    /**
     *  app用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "app用户id")
    private Integer userId;
	
	    /**
     *  是否有效:0-有效；1-无效
     */
    @Column(name = "is_valid")
	@ApiModelProperty(value = "是否有效:0-有效；1-无效")
    private Integer isValid;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
